﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class ArmeTour : MonoBehaviour {
	public enum TOUR{
		TOUR1,
		TOUR2
	};
	public TOUR tour = TOUR.TOUR1;
	public float compteurmax=10.0f;
	public GameObject bullet;
	public GameObject emplacement;

	private bool aTire ;
	private float delaiEntreTir;
	private float compteurTemps;
	private float compteurtir=0;

	void Start () {
		aTire = false;
		if (tour == TOUR.TOUR1){
			delaiEntreTir=0.2f;
		}
		if (tour == TOUR.TOUR2){
			delaiEntreTir=1.5f;
		}
	}
	
	void Update () {
		if (Game.instance.state==Game.STATES.JEU){
			compteurTemps += Time.deltaTime;
			if (compteurTemps >= compteurmax) {
				GameObject place = Instantiate(emplacement,transform.position,Quaternion.identity) as GameObject ;
				if (Game.instance.niveau==1){
					place.transform.parent = Game.instance.placementTourelle1.transform ;
				}
				if (Game.instance.niveau==2){
					place.transform.parent = Game.instance.placementTourelle2.transform ;
				}
				place.transform.rotation=transform.rotation;
				Destroy (gameObject);
			}
			
			if (!aTire) {
				int ennemiCible = 0;
				int nbennemi = 0;
				List<GameObject> ennemiInZone = new List<GameObject> ();
				
				foreach (GameObject ennemi in Game.instance.ennemi) {
					float distance = Vector3.Distance (ennemi.transform.position, transform.position);
					if (distance < 10) {
						nbennemi++;
						ennemiInZone.Add (ennemi);
					}
				}
				if (nbennemi > 0) {
					ennemiCible = Random.Range (0, nbennemi);
					aTire = true;
					Vector3 vecteurDirecteur = new Vector3(ennemiInZone[ennemiCible].transform.position.x-transform.position.x,ennemiInZone[ennemiCible].transform.position.y-transform.position.y,ennemiInZone[ennemiCible].transform.position.z-transform.position.z); 
					GameObject bull = Instantiate(bullet,new Vector3(transform.position.x,transform.position.y+2,transform.position.z),Quaternion.identity) as GameObject;
					bull.rigidbody.AddForce(vecteurDirecteur * 70);
					Destroy (bull,5.0f);
				}
			} 
			else {
				compteurtir+=Time.deltaTime;
				if (compteurtir >= delaiEntreTir){
					aTire=false;
					compteurtir=0;
				}
			}
		}
	}
}